;;  Programm:      ACM-LAENGSKAL.LSP
;;  Befehlsaufruf: ACM-LAENGSKAL
;;  Funktion:      Skaliert Objekte mit Lngendefinition anhand ihrer Lnge.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         22.03.2023
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-laengskal ( / las60 las61 las62 las48 sal01 sal02 sal03 sal04 sal05 sal06 sal07 sal08 sal09 sal10 sal11 sal12 sal13 sal14 sal15 sal16 sal17 sal18)
    (defun sal01 (las01 / )
      (if (= (logand las01 1) 1)
        (set_tile "endpunkt" "1")
        (set_tile "endpunkt" "0")
      )
      (if (= (logand las01 2) 2)
        (set_tile "mittelpunkt" "1")
        (set_tile "mittelpunkt" "0")
      )
      (if (= (logand las01 4) 4)
        (set_tile "zentrum" "1")
        (set_tile "zentrum" "0")
      )
      (if (= (logand las01 8) 8)
        (set_tile "punkt" "1")
        (set_tile "punkt" "0")
      )
      (if (= (logand las01 16) 16)
        (set_tile "quadrant" "1")
        (set_tile "quadrant" "0")
      )
      (if (= (logand las01 32) 32)
        (set_tile "schnittpunkt" "1")
        (set_tile "schnittpunkt" "0")
      )
      (if (= (logand las01 64) 64)
        (set_tile "basispunkt" "1")
        (set_tile "basispunkt" "0")
      )
      (if (= (logand las01 128) 128)
        (set_tile "lot" "1")
        (set_tile "lot" "0")
      )
      (if (= (logand las01 256) 256)
        (set_tile "tangente" "1")
        (set_tile "tangente" "0")
      )
      (if (= (logand las01 512) 512)
        (set_tile "naechsterpunkt" "1")
        (set_tile "naechsterpunkt" "0")
      )
      (if (= (logand las01 1024) 1024)
        (set_tile "geomzentrum" "1")
        (set_tile "geomzentrum" "0")
      )
      (if (= (logand las01 2048) 2048)
        (set_tile "angenschnittp" "1")
        (set_tile "angenschnittp" "0")
      )
      (if (= (logand las01 4096) 4096)
        (set_tile "hilfslinie" "1")
        (set_tile "hilfslinie" "0")
      )
      (if (= (logand las01 8192) 8192)
        (set_tile "parallel" "1")
        (set_tile "parallel" "0")
      )
    )
    (defun sal02 (las02 / las11)
        (if (not (vl-position acmlaengskal222032023 (list 0 1)))
          (setq acmlaengskal222032023 0)
        )
        (if (= acmlaengskal222032023 1)
          (setvar "OSMODE" acmlaengskal122032023)
        )
        (while (not las11)
          (initget 14 "objEkt")
          (setq las11 (getdist (strcat "\nNeue Lnge angeben oder [objEkt] <" (rtos las02) ">: ")))
            (if (not las11)
              (setq las11 las02)
                (progn
                  (if (= (type las11) 'STR)
                    (setq las11 (sal15))
                  )
                )
            )
        )
      (setvar "OSMODE" las62)
      las11
    )
    (defun sal03 (las03 / las12)
      (setq las12 acmlaengskal122032023)
        (if (= las03 0)
          (progn
            (setq acmlaengskal122032023 0)
              (if (= (get_tile "endpunkt") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 1))
              )
              (if (= (get_tile "mittelpunkt") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 2))
              )
              (if (= (get_tile "zentrum") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 4))
              )
              (if (= (get_tile "punkt") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 8))
              )
              (if (= (get_tile "quadrant") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 16))
              )
              (if (= (get_tile "schnittpunkt") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 32))
              )
              (if (= (get_tile "basispunkt") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 64))
              )
              (if (= (get_tile "lot") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 128))
              )
              (if (= (get_tile "tangente") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 256))
              )
              (if (= (get_tile "naechsterpunkt") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 512))
              )
              (if (= (get_tile "geomzentrum") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 1024))
              )
              (if (= (get_tile "angenschnittp") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 2048))
              )
              (if (= (get_tile "hilfslinie") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 4096))
              )
              (if (= (get_tile "parallel") "1")
                (setq acmlaengskal122032023 (+ acmlaengskal122032023 8192))
              )
          )
          (progn
            (if (= (get_tile "aktverw") "0")
              (progn
                (setq acmlaengskal222032023 1)
                (setq acmlaengskal122032023 0)
                  (if (= (get_tile "endpunkt") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 1))
                  )
                  (if (= (get_tile "mittelpunkt") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 2))
                  )
                  (if (= (get_tile "zentrum") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 4))
                  )
                  (if (= (get_tile "punkt") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 8))
                  )
                  (if (= (get_tile "quadrant") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 16))
                  )
                  (if (= (get_tile "schnittpunkt") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 32))
                  )
                  (if (= (get_tile "basispunkt") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 64))
                  )
                  (if (= (get_tile "lot") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 128))
                  )
                  (if (= (get_tile "tangente") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 256))
                  )
                  (if (= (get_tile "naechsterpunkt") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 512))
                  )
                  (if (= (get_tile "geomzentrum") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 1024))
                  )
                  (if (= (get_tile "angenschnittp") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 2048))
                  )
                  (if (= (get_tile "hilfslinie") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 4096))
                  )
                  (if (= (get_tile "parallel") "1")
                    (setq acmlaengskal122032023 (+ acmlaengskal122032023 8192))
                  )
              )
              (setq acmlaengskal222032023 0)
            )
          )
        )
    )
    (defun sal04 (las04 / las14)
        (if (= (type las06) 'VLA-OBJECT)
          (setq las04 (vlax-vla-object->ename las04))
        )
        (if
          (and
            (setq las14 (vla-get-ObjectName (vlax-ename->vla-object las04)))
            (vl-position (strcase las14) '("ACDB2DPOLYLINE" "ACDB3DPOLYLINE" "ACDBARC" "ACDBCIRCLE" "ACDBELLIPSE" "ACDBHELIX" "ACDBLINE" "ACDBPOLYLINE" "ACDBSPLINE"))
          )
            (setq las15 (vlax-curve-getDistAtParam las04 (vlax-curve-getEndParam las04)))
            (setq las15 nil)
        )
    )
    (defun sal05 ( / las16 las17 las55)
      (setq las16 acmlaengskal222032023)
      (setq las17 "")
        (while (= (type las17) 'STR)
            (if (= acmlaengskal222032023 1)
              (setvar "OSMODE" acmlaengskal122032023)
              (setvar "OSMODE" las62)
            )
          (initget 14 "objEktfangmodi")
          (setq las17 (getpoint "\nBasispunkt angeben oder [objEktfangmodi]: "))
            (if (= (type las17) 'STR)
              (sal07 1)
            )
        )
      (setvar "OSMODE" las62)
      las17
    )
    (defun sal06 (las03 / las18 las19 las20 las21 las22 las23)
      (if
        (and
          (setq las18 (vl-filename-mktemp "acm.dcl"))
          (setq las19 (open las18 "w"))
        )
          (progn
            (setq las20
              (list
                "laengskal"
                ":dialog{key=\042title\042;"
                ":spacer{height=0.5;}"
              )
            )
              (if (= las03 1)
                (setq las21
                  (list
                    ":toggle{key=\042aktverw\042;label=\042Aktuelle ver&wenden\042;}"
                    ":spacer{height=0.5;}"
                  )
                )
                (setq las21 nil)
              )
            (setq las22
              (list
                ":row{"
                ":spacer{width=0;}"
                ":column{"
                ":toggle{key=\042endpunkt\042;label=\042&Endpunkt\042;}"
                ":toggle{key=\042mittelpunkt\042;label=\042&Mittelpunkt\042;}"
                ":toggle{key=\042zentrum\042;label=\042&Zentrum\042;}"
                ":toggle{key=\042geomzentrum\042;label=\042Ge&om. Zentr.\042;}"
                ":toggle{key=\042punkt\042;label=\042P&unkt\042;}"
                ":toggle{key=\042quadrant\042;label=\042&Quadrant\042;}"
                ":toggle{key=\042schnittpunkt\042;label=\042&Schnittpunkt\042;}}"
                ":column{"
                ":toggle{key=\042hilfslinie\042;label=\042H&ilfslinie\042;}"
                ":toggle{key=\042basispunkt\042;label=\042&Basispunkt\042;}"
                ":toggle{key=\042lot\042;label=\042&Lot\042;}"
                ":toggle{key=\042tangente\042;label=\042Ta&ngente\042;}"
                ":toggle{key=\042naechsterpunkt\042;label=\042N&chster Punkt\042;}"
                ":toggle{key=\042angenschnittp\042;label=\042&Angen. Schnittp.\042;}"
                ":toggle{key=\042parallel\042;label=\042&Parallel\042;}}}"
                ":spacer{height=0.6;}"
                ":row{"
                ":spacer{width=4;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042ok\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042abbrechen\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=4;}}}"
              )
            )
            (setq las23 (append las20 las21 las22))
              (while las23
                (write-line (car las23) las19)
                (setq las23 (cdr las23))
              )
            (setq las19 (close las19))
            las18
          )
          nil
      )
    )
    (defun sal07 (las03 / las24 las25 las26)
      (if (setq las24 (sal06 las03))
        (progn
          (setq las25 (load_dialog las24))
            (if (not (new_dialog "laengskal" las25))
              (exit)
            )
          (vl-catch-all-apply 'vl-file-delete (list las24))
          (set_tile "title" (strcat (nth las03 (list "Befehlsabh. " "")) "Objektfangmodi"))
          (sal01 (nth acmlaengskal222032023 (list las62 acmlaengskal122032023)))
            (if (= las03 1)
              (progn
                (set_tile "aktverw" (itoa (setq las26 (nth acmlaengskal222032023 (list 1 0)))))
                   (foreach tile (list "endpunkt" "mittelpunkt" "zentrum" "punkt" "quadrant" "schnittpunkt" "basispunkt" "lot" "tangente" "naechsterpunkt" "geomzentrum" "angenschnittp" "hilfslinie" "parallel")
                     (mode_tile tile las26)
                   )
              )
            )
            (action_tile "aktverw" "(setq las27 (atoi $value))
                (foreach tile (list \"endpunkt\" \"mittelpunkt\" \"zentrum\" \"punkt\" \"quadrant\" \"schnittpunkt\" \"basispunkt\" \"lot\" \"tangente\" \"naechsterpunkt\" \"geomzentrum\" \"angenschnittp\" \"hilfslinie\" \"parallel\")
                  (mode_tile tile (nth las27 (list 0 1)))
                )
              (sal01 (nth las27 (list acmlaengskal122032023 las62)))"
            )
          (action_tile "ok" "(sal03 las03) (done_dialog)")
          (action_tile "abbrechen" "(done_dialog)")
          (start_dialog)
          (unload_dialog las25)
        )
      )
    )
    (defun sal08 ( / las28)
      (setq las28 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= las28 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq las15 T)
            (setq las15 nil)
        )
        (if (not las15)
          (alert "\042acm-laengskal\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      las15
    )
    (defun sal09 (las05 / )
      (if las42 (setvar "PICKBOX" las42))
      (if las62 (setvar "OSMODE" las62))
      (if las35 (setvar "DIMZIN" las35))
      (if las48 (setvar "LUPREC" las48))
      (if las61 (setq *error* las61))
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun sal10 ( / las29 las30 las17 las31 las32)
      (if
        (and
          (setq las29 (sal17))
          (setq las30 (sal18 las29))
          (setq las17 (sal05))
        )
          (progn
              (if (= (nth 3 las30) 1)
                (setq las31 (vla-Copy (car las29)))
                (setq las31 (car las29))
              )
              (if (= (car las30) 0)
                (setq las32 (/ (* (cadr las30) (nth 4 las30)) 100.0))
                (setq las32 (nth 2 las30))
              )
            (sal11 las31 las32 las17)
          )
      )
    )
    (defun sal11 (las06 las07 las08 / las33 las34 las35)
        (if (= (type las06) 'ENAME)
          (setq las06 (vlax-ename->vla-object las06))
        )
      (setq las33 (sal04 las06))
      (setq las08 (vlax-3D-point (trans las08 1 0)))
      (setq las34 (/ las07 las33))
      (vla-ScaleEntity las06 las08 las34)
      (setq las35 (getvar "DIMZIN"))
      (setvar "DIMZIN" 8)
        (prompt
          (strcat
            "\nAlte Lnge = "
            (rtos las33)
            ", neue Lnge = "
            (rtos las07)
            ", Skalierfaktor = "
            (rtos las34 2)
            " "
          )
        )
      (setvar "DIMZIN" las35)
    )
    (defun sal12 (las03 / )
      (if (= (type (vl-catch-all-apply 'setvar (list "OSMODE" acmlaengskal122032023))) 'VL-CATCH-ALL-APPLY-ERROR)
        (setq acmlaengskal122032023 0)
      )
      (if (not (vl-position acmlaengskal222032023 (list 0 1)))
        (setq acmlaengskal222032023 0)
      )
      (if (not (vl-position acmlaengskal322032023 (list 0 1)))
        (setq acmlaengskal322032023 0)
      )
      (if (not (vl-position acmlaengskal422032023 (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
        (progn
          (setq acmlaengskal322032023 0)
          (setq acmlaengskal422032023 (getvar "PICKBOX"))
        )
      )
      (if (not (vl-position acmlaengskal522032023 (list 0 1)))
        (setq acmlaengskal522032023 0)
      )
      (if (= las03 1)
        (prompt
          (strcat
            "\nAktuelle Einstellungen fr Lngenangabe per Objektwahl: Pickbox-Gre = "
              (if (= acmlaengskal322032023 0)
                (strcat "Aktuelle (" (itoa (getvar "PICKBOX")) ")")
                (itoa acmlaengskal422032023)
              )
            ", Blockelemente whlbar = "
            (nth acmlaengskal522032023 (list "Nein" "Ja"))
          )
        )
      )
    )
    (defun sal13 ( / las18 las19 las23)
      (if
        (and
          (setq las18 (vl-filename-mktemp "acm.dcl"))
          (setq las19 (open las18 "w"))
        )
          (progn
            (setq las23
              (list
                "acm_ccs"
                ":dialog{label=\042Einstellungen\042;"
                ":spacer{height=0.2;}"
                ":popup_list{key=\042pl_01\042;label=\042&Pickbox-Gre:\042;edit_width=8;}"
                ":spacer{height=0.3;}"
                ":toggle{key=\042tg_01\042;label=\042&Blockelemente whlbar\042;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=0;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=0;}}}"
              )
            )
              (while las23
                (write-line (car las23) las19)
                (setq las23 (cdr las23))
              )
            (setq las19 (close las19))
            las18
          )
          nil
      )
    )
    (defun sal14 ( / las24 las25 las39 las40)
        (if (not (vl-position acmlaengskal522032023 (list 0 1)))
          (setq acmlaengskal522032023 0)
        )
        (if (not (vl-position acmlaengskal422032023 (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
          (progn
            (setq acmlaengskal322032023 0)
            (setq acmlaengskal422032023 (getvar "PICKBOX"))
          )
        )
        (if (not (vl-position acmlaengskal322032023 (list 0 1)))
          (setq acmlaengskal322032023 0)
        )
        (if (setq las24 (sal13))
          (progn
            (setq las25 (load_dialog las24))
              (if (not (new_dialog "acm_ccs" las25))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list las24))
            (start_list "pl_01")
            (mapcar 'add_list (list (strcat "Akt. (" (itoa (getvar "PICKBOX")) ")") "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20"))
            (end_list)
            (set_tile "tg_01" (itoa acmlaengskal522032023))
              (if (= acmlaengskal322032023 0)
                (set_tile "pl_01" "0")
                (set_tile "pl_01" (itoa acmlaengskal422032023))
              )
              (action_tile "b_01" "(setq las39 (atoi (get_tile \"pl_01\")))
                  (if (= las39 0)
                    (progn
                      (setq acmlaengskal322032023 0)
                      (setq acmlaengskal422032023 (getvar \"PICKBOX\"))
                    )
                    (progn
                      (setq acmlaengskal322032023 1)
                      (setq acmlaengskal422032023 las39)
                    )
                  )
                (setq las40 (list (setq acmlaengskal522032023 (atoi (get_tile \"tg_01\"))) acmlaengskal322032023 acmlaengskal422032023))
                (done_dialog)
                (sal12 1)"
              )
            (action_tile "b_02" "(setq las40 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog las25)
          )
        )
      las40
    )
    (defun sal15 ( / las41 las42 las43 las44 las45 las46)
        (if (not (vl-position acmlaengskal522032023 (list 0 1)))
          (setq acmlaengskal522032023 0)
        )
        (if (not (vl-position acmlaengskal422032023 (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
          (progn
            (setq acmlaengskal322032023 0)
            (setq acmlaengskal422032023 (getvar "PICKBOX"))
          )
        )
      (sal12 1)
      (setq las41 (getvar "ERRNO"))
      (setq las42 (getvar "PICKBOX"))
      (setvar "ERRNO" 7)
        (while (= (getvar "ERRNO") 7)
          (setq las43 (nth acmlaengskal522032023 (list entsel nentsel)))
          (setvar "ERRNO" 0)
          (setvar "PICKBOX" acmlaengskal422032023)
          (initget "Einstellungen")
          (setq las44 (las43 "\nObjekt mit Lngendefinition whlen oder [Einstellungen]: "))
          (setvar "PICKBOX" las42)
            (if (= (getvar "ERRNO") 7)
              (princ "0 gefunden")
              (progn
                (if las44
                  (progn
                    (if (= (setq las45 (type las44)) 'LIST)
                      (progn
                        (if (not (setq las46 (sal04 (car las44))))
                          (progn
                            (prompt "\nGewhltes Objekt besitzt keine Lngendefinition. ")
                            (setvar "ERRNO" 7)
                            (setq las44 nil)
                          )
                          (progn
                            (if (= las46 0.0)
                              (progn
                                (prompt "\nGewhltes Objekt muss eine Lnge > 0 besitzen. ")
                                (setvar "ERRNO" 7)
                                (setq las44 nil)
                              )
                            )
                          )
                        )
                      )
                      (progn
                        (sal14)
                        (setvar "ERRNO" 7)
                        (setq las44 nil)
                      )
                    )
                  )
                )
              )
            )
        )
      (setvar "ERRNO" las41)
      las46
    )
    (defun sal16 ( / las18 las19 las23)
      (if
        (and
          (setq las18 (vl-filename-mktemp "acm.dcl"))
          (setq las19 (open las18 "w"))
        )
          (progn
            (setq las23
              (list
                "acm232_01"
                ":dialog{label=\042Lnge ndern\042;"
                ":spacer{height=0.4;}"
                ":text{key=\042t_01\042;}"
                ":spacer{height=0.4;}"
                ":row{"
                ":column{"
                ":radio_button{key=\042rb_01\042;label=\042&Prozent:\042;}"
                ":radio_button{key=\042rb_02\042;label=\042&Lnge:\042;}}"
                ":column{"
                ":edit_box{key=\042eb_01\042;allow_accept=true;}"
                ":row{"
                ":edit_box{key=\042eb_02\042;width=15;allow_accept=true;}"
                ":button{key=\042b_01\042;label=\042<\042;}}}}"
                ":spacer{height=0.6;}"
                ":boxed_column{label=\042Objektfangmodi\042;"
                ":radio_button{key=\042ofmaktuelle\042;label=\042Aktuelle &verwenden\042;}"
                ":row{"
                ":radio_button{key=\042ofmbefabh\042;label=\042&Befehlsabh. verw.\042;}"
                ":button{key=\042...\042;label=\042...\042;}}}"
                ":spacer{height=0.2;}"
                ":toggle{key=\042tg_01\042;label=\042&Kopie ndern\042;}"
                ":spacer{height=0.7;}"
                ":row{"
                ":spacer{width=5;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_02\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_03\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=5;}}}"
              )
            )
              (while las23
                (write-line (car las23) las19)
                (setq las23 (cdr las23))
              )
            (setq las19 (close las19))
            las18
          )
          nil
      )
    )
    (defun sal17 ( / las41 las42 las43 las44 las45 las46)
      (setq las41 (getvar "ERRNO"))
      (setvar "ERRNO" 7)
        (while (= (getvar "ERRNO") 7)
          (setvar "ERRNO" 0)
          (setq las44 (entsel "\nZu nderndes Objekt whlen: "))
            (if (= (getvar "ERRNO") 7)
              (princ "0 gefunden")
              (progn
                (if las44
                  (progn
                    (if (= (setq las45 (type las44)) 'LIST)
                      (progn
                        (if (not (setq las46 (sal04 (car las44))))
                          (progn
                            (prompt "\nGewhltes Objekt besitzt keine Lngendefinition. ")
                            (setvar "ERRNO" 7)
                            (setq las44 nil)
                          )
                          (progn
                            (if
                              (or
                                (= las46 0.0)
                                (= (vla-get-Lock (vlax-ename->vla-object (tblobjname "LAYER" (vla-get-Layer (setq las47 (vlax-ename->vla-object (car las44))))))) :vlax-true)
                              )
                                (progn
                                  (setvar "ERRNO" 7)
                                  (setq las44 nil)
                                    (if (= las46 0.0)
                                      (prompt "\nGewhltes Objekt muss eine Lnge > 0 besitzen. ")
                                      (prompt "\nGewhltes Objekt liegt auf einem gesperrten Layer. ")
                                    )
                                )
                            )
                          )
                        )
                      )
                    )
                  )
                )
              )
            )
        )
      (setvar "ERRNO" las41)
        (if las44
          (list (vlax-ename->vla-object (car las44)) las46)
        )
    )
    (defun sal18 (las09 / las48 las35 las49 las50 las24 las25 las56 las57 las58 las59 las55)
      (setq las48 (getvar "LUPREC"))
      (setq las35 (getvar "DIMZIN"))
      (setvar "LUPREC" 8)
      (setvar "DIMZIN" 8)
        (if (not las49)
          (setq las49 (list -1 -1))
        )
      (setq las50 1)
        (if (setq las24 (sal16))
          (progn
            (setq las25 (load_dialog las24))
            (vl-catch-all-apply 'vl-file-delete (list las24))
              (while (> las50 0)
                  (if (not (new_dialog "acm232_01" las25 "" las49))
                    (exit)
                  )
                  (if (not (vl-position acmlaengskal222032023 (list 0 1)))
                    (setq acmlaengskal222032023 0)
                  )
                  (if (not (vl-position acmlaengskal622032023 (list 0 1)))
                    (setq acmlaengskal622032023 1)
                  )
                  (if (not (vl-position acmlaengskal722032023 (list 0 1)))
                    (setq acmlaengskal722032023 0)
                  )
                  (if
                    (not
                      (and
                        (vl-position (type acmlaengskal822032023) (list 'INT 'REAL))
                        (> acmlaengskal822032023 0.0)
                      )
                    )
                      (setq acmlaengskal822032023 50.0)
                  )
                  (if
                    (not
                      (and
                        (vl-position (type acmlaengskal922032023) (list 'INT 'REAL))
                        (> acmlaengskal922032023 0.0)
                      )
                    )
                      (setq acmlaengskal922032023 100.0)
                  )
                (set_tile "t_01" (strcat "Akt. Lnge:  " (rtos (cadr las09))))
                (set_tile "eb_01" (rtos acmlaengskal822032023 2))
                  (if (= acmlaengskal622032023 0)
                    (progn
                      (set_tile "rb_01" "1")
                      (mode_tile "eb_02" 1)
                      (mode_tile "b_01" 1)
                    )
                    (progn
                      (set_tile "rb_02" "1")
                      (mode_tile "eb_01" 1)
                    )
                  )
                  (if (= acmlaengskal222032023 0)
                    (progn
                      (set_tile "ofmaktuelle" "1")
                      (mode_tile "..." 1)
                    )
                      (set_tile "ofmbefabh" "1")
                  )
                (set_tile "tg_01" (itoa acmlaengskal722032023))
                (set_tile "eb_02" (rtos acmlaengskal922032023))
                  (if (= (get_tile "rb_02") "1")
                    (mode_tile "eb_02" 2)
                    (mode_tile "eb_01" 2)
                  )
                (action_tile "ofmaktuelle" "(set_tile \"ofmbefabh\" \"0\") (mode_tile \"...\" 1)")
                (action_tile "ofmbefabh" "(set_tile \"ofmaktuelle\" \"0\") (mode_tile \"...\" 0) (mode_tile \"...\" 2)")
                (action_tile "..." "(if (setq las55 (sal07 0)) (setq acmlaengskal122032023 (cadr las55)))")
                  (action_tile "rb_01" "(mode_tile \"eb_01\" 0)
                    (mode_tile \"eb_01\" 2)
                    (setq acmlaengskal622032023 0)
                    (mode_tile \"eb_02\" 1)
                    (mode_tile \"b_01\" 1)"
                  )
                  (action_tile "rb_02" "(mode_tile \"eb_01\" 1)
                    (setq acmlaengskal622032023 1)
                    (mode_tile \"eb_02\" 0)
                    (mode_tile \"eb_02\" 2)
                    (mode_tile \"b_01\" 0)"
                  )
                  (action_tile "b_01" "(setq acmlaengskal722032023 (atoi (get_tile \"tg_01\")))
                    (setq acmlaengskal222032023 (atoi (get_tile \"ofmbefabh\")))
                    (setq acmlaengskal822032023 (distof (get_tile \"eb_01\")))
                    (setq acmlaengskal922032023 (distof (get_tile \"eb_02\")))
                    (setq las49 (done_dialog 1))"
                  )
                  (action_tile "b_02" "(if (= (get_tile \"rb_01\") \"1\")
                    (progn
                      (if
                        (and
                          (setq las56 (distof (get_tile \"eb_01\")))
                          (> las56 0.0)
                        )
                          (setq las57 (list (setq acmlaengskal622032023 0) (setq acmlaengskal822032023 las56) (setq acmlaengskal922032023 (distof (get_tile \"eb_02\"))) (setq acmlaengskal722032023 (atoi (get_tile \"tg_01\"))) (cadr las09)))
                          (progn
                            (setq las57 nil)
                            (alert \"Ungltige Eingabe fr Prozent.\")
                            (mode_tile \"eb_01\" 2)
                          )
                      )
                    )
                    (progn
                      (if
                        (and
                          (setq las58 (distof (get_tile \"eb_02\")))
                          (> las58 0.0)
                        )
                          (setq las57 (list (setq acmlaengskal622032023 1) (setq acmlaengskal822032023 (distof (get_tile \"eb_01\"))) (setq acmlaengskal922032023 las58) (setq acmlaengskal722032023 (atoi (get_tile \"tg_01\"))) (cadr las09)))
                          (progn
                            (setq las57 nil)
                            (alert \"Ungltige Eingabe fr Lnge.\")
                            (mode_tile \"eb_02\" 2)
                          )
                      )
                    )
                    )
                    (if las57
                      (progn
                        (setq acmlaengskal222032023 (atoi (get_tile \"ofmbefabh\")))
                        (done_dialog 0)))"
                  )
                (action_tile "b_03" "(done_dialog 0)")
                (setq las50 (start_dialog))
                  (if (= las50 1)
                    (progn
                      (if (setq las59 (sal02 acmlaengskal922032023))
                        (setq acmlaengskal922032023 las59)
                      )
                    )
                  )
              )
            (unload_dialog las25)
          )
        )
      (setvar "LUPREC" las48)
      (setvar "DIMZIN" las35)
      las57
    )
  (if (sal08)
    (progn
      (vl-load-com)
      (setq las60 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq las61 *error*)
      (setq *error* sal09)
      (setq las62 (getvar "OSMODE"))
      (vla-EndUndoMark las60)
      (vla-StartUndoMark las60)
      (sal12 0)
      (setq las48 (getvar "LUPREC"))
      (setvar "LUPREC" 8)
      (sal10)
      (setvar "LUPREC" las48)
        (if las61
          (setq *error* las61)
          (setq *error* nil)
        )
      (vla-EndUndoMark las60)
      (setvar "OSMODE" las62)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-LAENGSKAL (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-LAENGSKAL auf.")
